<?php
/**
 * Migration Script: Add Topup Fields to Orders Table
 * 
 * این اسکریپت 2 فیلد جدید به جدول orders اضافه می‌کنه:
 * 1. order_type - برای تشخیص نوع سفارش (base یا topup)
 * 2. parent_order_id - لینک به eSIM اصلی (برای topup)
 * 
 * این فایل رو فقط یکبار اجرا کن!
 */

require_once __DIR__ . '/config/database.php';

echo "<!DOCTYPE html>
<html lang='fa' dir='rtl'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Migration: Add Topup Fields</title>
    <style>
        body {
            font-family: Tahoma, Arial, sans-serif;
            background: #f5f5f5;
            padding: 40px 20px;
            direction: rtl;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        h1 {
            color: #FF2929;
            margin-bottom: 30px;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
            border: 1px solid #c3e6cb;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
            border: 1px solid #f5c6cb;
        }
        .info {
            background: #d1ecf1;
            color: #0c5460;
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
            border: 1px solid #bee5eb;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: #FF2929;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            margin-top: 20px;
        }
        .btn:hover {
            background: #CB1919;
        }
        code {
            background: #f8f9fa;
            padding: 2px 8px;
            border-radius: 4px;
            font-family: monospace;
        }
    </style>
</head>
<body>
    <div class='container'>
        <h1>🔧 Migration: Add Topup Fields</h1>";

try {
    $conn = getDBConnection();
    
    echo "<div class='info'>
        <strong>✓ اتصال به دیتابیس موفق</strong><br>
        در حال بررسی جدول orders...
    </div>";
    
    // Check if fields already exist
    $result = $conn->query("SHOW COLUMNS FROM orders LIKE 'order_type'");
    $orderTypeExists = ($result->num_rows > 0);
    
    $result = $conn->query("SHOW COLUMNS FROM orders LIKE 'parent_order_id'");
    $parentOrderIdExists = ($result->num_rows > 0);
    
    $result = $conn->query("SHOW COLUMNS FROM orders LIKE 'esim_tran_no'");
    $esimTranNoExists = ($result->num_rows > 0);
    
    if ($orderTypeExists && $parentOrderIdExists && $esimTranNoExists) {
        echo "<div class='success'>
            <strong>✅ همه فیلدها از قبل وجود دارند!</strong><br>
            <ul>
                <li>✓ order_type</li>
                <li>✓ parent_order_id</li>
                <li>✓ esim_tran_no</li>
            </ul>
            نیازی به migration نیست.
        </div>";
    } else {
        echo "<div class='info'>
            <strong>📝 فیلدهای موجود:</strong><br>
            <ul>
                <li>" . ($orderTypeExists ? '✓' : '✗') . " order_type</li>
                <li>" . ($parentOrderIdExists ? '✓' : '✗') . " parent_order_id</li>
                <li>" . ($esimTranNoExists ? '✓' : '✗') . " esim_tran_no</li>
            </ul>
        </div>";
        
        // Add missing fields
        $queries = [];
        
        if (!$orderTypeExists) {
            $queries[] = "ALTER TABLE orders ADD COLUMN order_type VARCHAR(20) DEFAULT 'base' AFTER status";
        }
        
        if (!$parentOrderIdExists) {
            $queries[] = "ALTER TABLE orders ADD COLUMN parent_order_id INT NULL DEFAULT NULL AFTER order_type";
        }
        
        if (!$esimTranNoExists) {
            $queries[] = "ALTER TABLE orders ADD COLUMN esim_tran_no VARCHAR(50) NULL DEFAULT NULL AFTER esim_id";
        }
        
        foreach ($queries as $query) {
            if ($conn->query($query) === TRUE) {
                echo "<div class='success'>
                    ✅ Query executed successfully:<br>
                    <code>" . htmlspecialchars($query) . "</code>
                </div>";
            } else {
                echo "<div class='error'>
                    ❌ Query failed:<br>
                    <code>" . htmlspecialchars($query) . "</code><br>
                    Error: " . $conn->error . "
                </div>";
            }
        }
        
        echo "<div class='success'>
            <strong>🎉 Migration کامل شد!</strong><br>
            فیلدهای زیر به جدول orders اضافه شدند:
            <ul>
                <li><code>order_type</code> - نوع سفارش (base یا topup)</li>
                <li><code>parent_order_id</code> - لینک به eSIM اصلی</li>
                <li><code>esim_tran_no</code> - شماره transaction از API</li>
            </ul>
        </div>";
    }
    
    // Show table structure
    echo "<div class='info'>
        <strong>📊 ساختار جدول orders بعد از migration:</strong><br><br>";
    
    $result = $conn->query("SHOW COLUMNS FROM orders");
    echo "<table style='width: 100%; border-collapse: collapse; font-size: 0.9rem;'>
        <tr style='background: #f8f9fa; font-weight: bold;'>
            <td style='padding: 8px; border: 1px solid #ddd;'>Field</td>
            <td style='padding: 8px; border: 1px solid #ddd;'>Type</td>
            <td style='padding: 8px; border: 1px solid #ddd;'>Null</td>
            <td style='padding: 8px; border: 1px solid #ddd;'>Default</td>
        </tr>";
    
    while ($row = $result->fetch_assoc()) {
        // Highlight new fields
        $highlight = in_array($row['Field'], ['order_type', 'parent_order_id', 'esim_tran_no']) 
            ? "style='background: #d4edda;'" : "";
        
        echo "<tr $highlight>
            <td style='padding: 8px; border: 1px solid #ddd;'>" . htmlspecialchars($row['Field']) . "</td>
            <td style='padding: 8px; border: 1px solid #ddd;'>" . htmlspecialchars($row['Type']) . "</td>
            <td style='padding: 8px; border: 1px solid #ddd;'>" . htmlspecialchars($row['Null']) . "</td>
            <td style='padding: 8px; border: 1px solid #ddd;'>" . htmlspecialchars($row['Default'] ?? 'NULL') . "</td>
        </tr>";
    }
    
    echo "</table></div>";
    
    $conn->close();
    
    echo "<div class='success'>
        <strong>✅ تمام!</strong><br>
        حالا سیستم Topup کاملاً آماده است.
    </div>";
    
    echo "<div style='text-align: center; margin-top: 30px;'>
        <a href='/' class='btn'>بازگشت به سایت</a>
        <a href='my-esims.php' class='btn'>تست دکمه شارژ</a>
    </div>";
    
    echo "<div class='info' style='margin-top: 30px;'>
        <strong>⚠️ توجه:</strong><br>
        بعد از اجرای موفق این اسکریپت، می‌تونی این فایل رو حذف کنی:<br>
        <code>add-topup-fields.php</code>
    </div>";
    
} catch (Exception $e) {
    echo "<div class='error'>
        <strong>❌ خطا در اتصال به دیتابیس:</strong><br>
        " . $e->getMessage() . "
    </div>";
    
    echo "<div class='info'>
        <strong>💡 راهنمای عیب‌یابی:</strong>
        <ul>
            <li>اطلاعات دیتابیس در <code>config/database.php</code> را چک کنید</li>
            <li>مطمئن شوید MySQL/MariaDB در حال اجراست</li>
            <li>مطمئن شوید کاربر دیتابیس دسترسی ALTER TABLE دارد</li>
        </ul>
    </div>";
}

echo "</div>
</body>
</html>";
?>

