# 🎯 شروع کار با سیستم eSIM

---

## ✨ خوش آمدید!

این یک سیستم **کامل و تمیز** برای فروش eSIM است که با دقت کامل از صفر نوشته شده.

---

## 🚀 سریع شروع کنید!

### مرحله 1: بخوانید! 📖

قبل از هر کاری، این فایل‌ها را بخوانید:

1. **UPLOAD_INSTRUCTIONS.txt** - چه فایلی کجا آپلود شود
2. **INSTALLATION_GUIDE.md** - راهنمای کامل نصب
3. **README.md** - معرفی پروژه

### مرحله 2: ویرایش کنید! ✏️

قبل از آپلود، این فایل‌ها را ویرایش کنید:

1. **config/database.php** → اطلاعات دیتابیس
2. **config/config.php** → اطلاعات API
3. **proxy-handler.php** → Merchant ID زرین‌پال

### مرحله 3: آپلود کنید! 📤

#### سرور آلمان:
```
همه چیز به جز proxy-handler.php
```

#### سرور ایران:
```
فقط proxy-handler.php
```

### مرحله 4: نصب کنید! ⚙️

```
https://esim.matinacard.com/install.php
```

### مرحله 5: تست کنید! ✅

```
https://esim.matinacard.com
```

---

## 📚 فهرست فایل‌های راهنما

| فایل | محتوا |
|------|-------|
| 📄 **START_HERE.md** | این فایل - شروع سریع |
| 📄 **README.md** | معرفی کامل پروژه |
| 📄 **INSTALLATION_GUIDE.md** | راهنمای نصب گام به گام |
| 📄 **UPLOAD_INSTRUCTIONS.txt** | دستورالعمل آپلود |
| 📄 **FILES_LIST.md** | لیست و توضیح تمام فایل‌ها |

---

## 🎨 ویژگی‌های سیستم

✅ طراحی مدرن و زیبا
✅ کاملاً فارسی
✅ Responsive و Mobile-friendly
✅ پرداخت امن با زرین‌پال
✅ سیستم Proxy برای سرورهای خارج
✅ مدیریت کامل سفارشات
✅ QR Code خودکار
✅ ایمیل خودکار (قابل افزودن)
✅ پنل کاربری
✅ مدیریت کاربران
✅ بدون باگ و خطا

---

## 🔧 نیازمندی‌ها

### سرور:
- PHP 7.4 یا بالاتر
- MySQL 5.7 یا بالاتر
- cURL enabled
- mod_rewrite enabled

### حساب‌های خارجی:
- eSIM Access API (Access Code + Security Key)
- ZarinPal Merchant ID

---

## 📋 چک‌لیست قبل از شروع

- [ ] اطلاعات دیتابیس را دارم
- [ ] Access Code و Security Key دارم
- [ ] Merchant ID زرین‌پال دارم
- [ ] دو سرور (آلمان + ایران) در دسترس است
- [ ] تمام راهنماها را خوانده‌ام

---

## 🎯 مراحل به ترتیب اولویت

```
1. خواندن UPLOAD_INSTRUCTIONS.txt
        ↓
2. ویرایش فایل‌های config
        ↓
3. آپلود فایل‌ها
        ↓
4. اجرای install.php
        ↓
5. تست سیستم
        ↓
6. حذف install.php
        ↓
7. تغییر رمز admin
        ↓
8. شروع فروش! 🎉
```

---

## ⚠️ نکات مهم

1. **قبل از آپلود**:
   - حتماً فایل‌های config را ویرایش کنید
   - Merchant ID را از زرین‌پال بگیرید

2. **حین نصب**:
   - install.php را فقط یکبار اجرا کنید
   - از دیتابیس خالی استفاده کنید

3. **بعد از نصب**:
   - install.php را حذف کنید
   - رمز admin را عوض کنید
   - یک خرید تستی انجام دهید

---

## 🐛 مشکل دارید؟

### 1. خطای دیتابیس:
```
→ اطلاعات در config/database.php را چک کنید
```

### 2. خطای Session:
```
→ مطمئن شوید قبل از <?php فضای خالی نیست
```

### 3. خطای 500:
```
→ PHP error log را بررسی کنید
```

### 4. بسته‌ها نمایش داده نمی‌شود:
```
→ Access Code و Security Key را چک کنید
```

### 5. پرداخت کار نمی‌کند:
```
→ Merchant ID در proxy-handler.php را چک کنید
→ اتصال سرور ایران به ZarinPal را بررسی کنید
```

---

## 📞 پشتیبانی

اگر مشکلی دارید:

📧 **Email:** support@matinacard.com
📱 **Telegram:** @matinacard
🌐 **Website:** https://esim.matinacard.com

---

## 🎉 آماده‌اید؟

حالا شروع کنید:

### مرحله بعدی:
```
👉 UPLOAD_INSTRUCTIONS.txt را باز کنید
```

---

<div align="center">

**با آرزوی موفقیت! 🚀**

سیستم eSIM - نسخه 1.0
ساخته شده با ❤️

</div>

---

